/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration;

import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import slimeknights.mantle.client.model.fluid.FluidTextureModel;
import slimeknights.mantle.fluid.attributes.FluidAttributes;

public class ModelFluidAttributes
extends FluidAttributes {
    public static final IFluidModelProvider MODEL_PROVIDER = (IFluidModelProvider)EnvExecutor.unsafeRunForDist(() -> () -> FluidTextureModel.LOADER, () -> () -> IFluidModelProvider.EMPTY);
    private final class_3611 fluid;

    public static FluidAttributes.Builder builder() {
        return new Builder(ModelFluidAttributes::new);
    }

    protected ModelFluidAttributes(FluidAttributes.Builder builder, class_3611 fluid) {
        super(builder, fluid);
        this.fluid = fluid;
    }

    @Override
    public class_2960 getStillTexture() {
        class_2960 texture = MODEL_PROVIDER.getStillTexture(this.fluid);
        if (texture == null) {
            return super.getStillTexture();
        }
        return texture;
    }

    @Override
    public class_2960 getFlowingTexture() {
        class_2960 texture = MODEL_PROVIDER.getFlowingTexture(this.fluid);
        if (texture == null) {
            return super.getFlowingTexture();
        }
        return texture;
    }

    @Override
    @Nullable
    public class_2960 getOverlayTexture() {
        return MODEL_PROVIDER.getOverlayTexture(this.fluid);
    }

    @Override
    public int getColor() {
        return MODEL_PROVIDER.getColor(this.fluid);
    }

    public static class Builder
    extends FluidAttributes.Builder {
        private static final class_2960 FALLBACK_STILL = new class_2960("block/water_still");
        private static final class_2960 FALLBACK_FLOWING = new class_2960("block/water_flow");

        protected Builder(BiFunction<FluidAttributes.Builder, class_3611, FluidAttributes> factory) {
            super(FALLBACK_STILL, FALLBACK_FLOWING, factory);
        }
    }

    public static interface IFluidModelProvider {
        public static final IFluidModelProvider EMPTY = new IFluidModelProvider(){};

        @Nullable
        default public class_2960 getStillTexture(class_3611 fluid) {
            return null;
        }

        @Nullable
        default public class_2960 getFlowingTexture(class_3611 fluid) {
            return null;
        }

        @Nullable
        default public class_2960 getOverlayTexture(class_3611 fluid) {
            return null;
        }

        default public int getColor(class_3611 fluid) {
            return -1;
        }
    }
}

